/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.config.UIInfoConfigBean;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.AbstractStatusMonitor;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.util.GraphicsConstants;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HMCStatusMonitor
extends AbstractStatusMonitor {
    private static final String HWMSGS_TEXT_KEY = "status.hmc.hwmsgs";
    private static final String NO_HWMSGS_TEXT_KEY = "status.hmc.nohwmsgs";
    private String shortId;
    private TaskUrl taskUrl;
    private boolean hasHWMsgs;

    public void init(UserObject userObj, String key, Map parameters, UIInfoConfigBean uiConfigBean) {
        super.init(userObj, key, parameters, uiConfigBean);
        ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
        objId.setKeyProperty("Name", "base.task.hwmsg");
        String taskId = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getShortId(objId);
        this.taskUrl = new TaskUrl(taskId, 2);
        this.shortId = this.getHMCShortId();
        if (this.shortId != null) {
            this.hasHWMsgs = UIObjectProperties.attentionsExist(userObj.getUIObjectsReader().getBuffer(this.shortId));
        }
    }

    public StatusMonitorBean getStatusMonitorBean() {
        if (this.shortId == null) {
            return null;
        }
        Locale locale = this.getUserObject().getLocale();
        String url = null;
        String statusImage = null;
        String[] details = null;
        if (!this.hasHWMsgs) {
            statusImage = GraphicsConstants.getNormalImageIcon();
            details = new String[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", NO_HWMSGS_TEXT_KEY).toString(locale)};
        } else {
            TaskUrl urlObj = (TaskUrl)this.taskUrl.clone();
            urlObj.setTarget(this.shortId);
            url = urlObj.toString();
            statusImage = GraphicsConstants.getWarningImageIcon();
            details = new String[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", HWMSGS_TEXT_KEY).toString(locale)};
        }
        UIInfo uiInfo = this.getUIInfo();
        return new StatusMonitorBean(this.getKey(), uiInfo.getName(locale), uiInfo.getCaption(locale), uiInfo.getImageName(), url, null, statusImage, details, !this.hasHWMsgs);
    }

    public boolean updateData() {
        UIObjectsReader reader = this.getUserObject().getUIObjectsReader();
        byte[] buffer = null;
        if (this.shortId == null) {
            this.shortId = this.getHMCShortId();
            if (this.shortId == null) {
                return false;
            }
            this.hasHWMsgs = UIObjectProperties.attentionsExist(reader.getBuffer(this.shortId));
            return true;
        }
        try {
            buffer = reader.getBuffer(this.shortId);
        }
        catch (InvalidIdException iiEx) {
            this.shortId = null;
            boolean hold = this.hasHWMsgs;
            boolean foundNewShortId = this.updateData();
            if (!foundNewShortId) {
                return true;
            }
            buffer = reader.getBuffer(this.shortId);
            this.hasHWMsgs = hold;
        }
        boolean newHWMsgsStatus = UIObjectProperties.attentionsExist(buffer);
        if (this.hasHWMsgs != newHWMsgsStatus) {
            this.hasHWMsgs = newHWMsgsStatus;
            return true;
        }
        return false;
    }

    public void validateParameters(Map parameters) {
    }

    private String getHMCShortId() {
        UIObjectsReader reader = this.getUserObject().getUIObjectsReader();
        Set ids = reader.getShortIdsByType((byte)55);
        if (ids.isEmpty()) {
            return null;
        }
        return (String)ids.iterator().next();
    }
}

